// Autor: Ante Derek

#include <iostream>
#include <cstring>
#include <cassert>

using namespace std;

const int MAX = 100;

int n;
int x[MAX];
int B[MAX][MAX];

int len(int x) {
  int l = x<=0?1:0;
  if (x < 0)
    x = -x;
  while (x > 0)
    l++, x/=10;
  return l;
}

int simple(int a, int b) {
  assert(a < b);
  int cnt = b-a+len(x[a]);
  for (int i=a+1; i<b; i++) 
    cnt += len(x[i]-x[i+1]);
  int sol = cnt;
  for (int i=a+1; i<b; i++) {
    cnt += len(x[i]-x[i-1])-len(x[i]-x[i+1]);
    sol = min(sol, cnt);
  }
  return sol;
}

int best(int a, int b) {
  if (b == a+1)
    return 1+len(x[a]);
  int &sol = B[a][b];
  if (sol != -1)
    return sol;
  sol = simple(a, b);
  for (int i=a+1; i<b; i++) 
    sol = min(sol, simple(a, i)+best(i, b));
  return sol;
}

int main() {
  cin >> n;
  for (int i=0; i<n; i++) 
    cin >> x[i];
  memset(B, -1, sizeof B);
  cout << best(0, n-1)+1+len(x[n-1]) << endl;
  return 0;
}

